/*
   This program is provided under the LGPL license ver 2.1.
   Written by Katsumi.
   http://hp.vector.co.jp/authors/VA016157/
   kmorimatsu@users.sourceforge.jp
*/

#include "./prototypes.h"

volatile unsigned char vram[768];

int g_cursor=0;
unsigned char g_cursor_char=0;
int g_blink_cursor_counter=2048;

inline void blink_cursor(){
	if (2048<=g_blink_cursor_counter) {
		if (g_blink_cursor_counter & 1) {
			vram[g_cursor]=g_cursor_char;
			g_blink_cursor_counter=0;
		} else {
			vram[g_cursor]=0x5f;
			g_blink_cursor_counter=1;
		}
	} else {
		g_blink_cursor_counter+=2;
	}
}

inline void print_char(unsigned char ascii){
	static unsigned char prev_ascii=0;
	// Reset cursor blinking
	g_blink_cursor_counter=2048;
	vram[g_cursor]=g_cursor_char;
	// Investigate ascii code
	switch(ascii){
	case 0x00: // Null
		break;
	case 0x07: // Bell
		// Currently do nothing.
		break;
	case 0x0a: // LF
		if (prev_ascii==0x0d) break; // Ignore if the previous ascii code is CR (0x0d).
	case 0x0d: // CR
		g_cursor&=~(32-1);
		g_cursor+=32;
		break;
	case 0x08: // BS
		g_cursor--;
		if (g_cursor<0) g_cursor=0;
		vram[g_cursor]=0;
		break;
	case 0x7f: // DEL
		// Currently do nowhing.
		break;
	case 0x11: // left
		if (0<g_cursor) g_cursor--;
		break;
	case 0x12: // up
		if (32<=g_cursor) g_cursor-=32;
		break;
	case 0x13: // right
		g_cursor++;
		break;
	case 0x14: // down
		g_cursor+=32;
		break;
	default:
		if (0x20<=ascii && ascii<0x80) {
			// Valid character.
			// Let's convert to graphic code
			ascii-=0x20;
		} else {
			// Invalid character. Show '?'
			ascii=0x1f;
		}
		// Show the character at the cursor position.
		vram[g_cursor]=ascii;
		// Shift the cursor.
		g_cursor++;
		break;
	}
	// Check if scroll up is needed.
	if ((32*24-1)<g_cursor) {
		int i;
		// Scroll up
		for(i=0;i<32*(24-1);i++){
			vram[i]=vram[i+32];
		}
		// Clear the last line.
		for(i=32*(24-1);i<(32*24);i++){
			vram[i]=0;
		}
		// Set the cursor position to lower left.
		g_cursor=32*(24-1);
	}
	prev_ascii=ascii;
	g_cursor_char=vram[g_cursor];
}


/*
 * The following cgrom data is constructed by using 'Misaki' 8x8 font.
 * http://www.geocities.jp/littlimi/misaki.htm
 *
 */

const unsigned char cgrom[]={

		// line #0
		0x00,0x10,0xd8,0x14,0x08,0x42,0x30,0xc0,0x02,0x80,0x10,0x10,0x00,0x00,0x00,0x02,
		0x3c,0x10,0x3c,0x3c,0x04,0x7e,0x3c,0x7e,0x3c,0x3c,0x00,0x00,0x02,0x00,0x80,0x3c,
		0x38,0x10,0x7c,0x1c,0x78,0x7e,0x7e,0x1c,0x42,0x38,0x02,0x42,0x40,0x82,0x42,0x18,
		0x7c,0x18,0x7c,0x3c,0xfe,0x42,0x82,0x82,0x82,0x82,0x7e,0x0e,0x80,0xe0,0x10,0x00,
		0x20,0x00,0x40,0x00,0x04,0x00,0x0c,0x00,0x40,0x10,0x08,0x20,0x30,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x10,0xc0,0x00,0xaa,

		// line #1
		0x00,0x10,0x48,0x7e,0x3e,0xa4,0x48,0x40,0x04,0x40,0x54,0x10,0x00,0x00,0x00,0x04,
		0x42,0x30,0x42,0x42,0x0c,0x40,0x42,0x02,0x42,0x42,0x30,0x30,0x04,0x00,0x40,0x42,
		0x44,0x28,0x42,0x22,0x44,0x40,0x40,0x22,0x42,0x10,0x02,0x44,0x40,0xc6,0x62,0x24,
		0x42,0x24,0x42,0x42,0x10,0x42,0x82,0x92,0x44,0x44,0x02,0x08,0x40,0x20,0x28,0x00,
		0x10,0x00,0x40,0x00,0x04,0x00,0x10,0x00,0x40,0x00,0x00,0x20,0x10,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x20,0x00,0x55,

		// line #2
		0x00,0x10,0x90,0x28,0x48,0x48,0x50,0x80,0x08,0x20,0x38,0x10,0x00,0x00,0x00,0x08,
		0x42,0x10,0x02,0x02,0x14,0x7c,0x40,0x04,0x42,0x42,0x30,0x30,0x08,0xfe,0x20,0x02,
		0x9a,0x28,0x42,0x40,0x42,0x40,0x40,0x40,0x42,0x10,0x02,0x48,0x40,0xaa,0x52,0x42,
		0x42,0x42,0x42,0x40,0x10,0x42,0x44,0x92,0x28,0x28,0x04,0x08,0x20,0x20,0x00,0x00,
		0x00,0x38,0x58,0x38,0x34,0x38,0x38,0x3c,0x58,0x10,0x08,0x24,0x10,0x68,0x58,0x38,
		0x78,0x3c,0x58,0x3c,0x78,0x44,0x44,0x44,0x44,0x44,0x7c,0x08,0x10,0x20,0x60,0xaa,

		// line #3
		0x00,0x10,0x00,0x28,0x3c,0x10,0x24,0x00,0x08,0x20,0x10,0xfe,0x00,0xfe,0x00,0x10,
		0x42,0x10,0x0c,0x1c,0x24,0x42,0x7c,0x08,0x3c,0x3e,0x00,0x00,0x10,0x00,0x10,0x0c,
		0xaa,0x44,0x7c,0x40,0x42,0x7c,0x7c,0x4e,0x7e,0x10,0x02,0x50,0x40,0xaa,0x4a,0x42,
		0x7c,0x42,0x7c,0x3c,0x10,0x42,0x44,0xaa,0x10,0x10,0x08,0x08,0x10,0x20,0x00,0x00,
		0x00,0x04,0x64,0x44,0x4c,0x44,0x10,0x44,0x64,0x10,0x08,0x28,0x10,0x54,0x64,0x44,
		0x44,0x44,0x64,0x40,0x20,0x44,0x44,0x54,0x28,0x28,0x08,0x10,0x10,0x10,0x92,0x55,

		// line #4
		0x00,0x10,0x00,0x28,0x12,0x24,0x54,0x00,0x08,0x20,0x38,0x10,0xc0,0x00,0x00,0x20,
		0x42,0x10,0x30,0x02,0x44,0x02,0x42,0x08,0x42,0x02,0x30,0x30,0x08,0xfe,0x20,0x10,
		0xb4,0x7c,0x42,0x40,0x42,0x40,0x40,0x42,0x42,0x10,0x02,0x68,0x40,0x92,0x46,0x42,
		0x40,0x4a,0x48,0x02,0x10,0x42,0x28,0xaa,0x28,0x10,0x10,0x08,0x08,0x20,0x00,0x00,
		0x00,0x3c,0x44,0x40,0x44,0x7c,0x10,0x3c,0x44,0x10,0x08,0x30,0x10,0x54,0x44,0x44,
		0x78,0x3c,0x40,0x38,0x20,0x44,0x28,0x54,0x10,0x28,0x10,0x08,0x10,0x20,0x0c,0xaa,

		// line #5
		0x00,0x00,0x00,0xfc,0x7c,0x4a,0x88,0x00,0x04,0x40,0x54,0x10,0x40,0x00,0xc0,0x40,
		0x42,0x10,0x40,0x42,0x7e,0x42,0x42,0x10,0x42,0x42,0x30,0x10,0x04,0x00,0x40,0x00,
		0x40,0x82,0x42,0x22,0x44,0x40,0x40,0x22,0x42,0x10,0x42,0x44,0x40,0x92,0x42,0x24,
		0x40,0x24,0x44,0x42,0x10,0x42,0x28,0x44,0x44,0x10,0x20,0x08,0x04,0x20,0x00,0x00,
		0x00,0x44,0x44,0x44,0x44,0x40,0x10,0x04,0x44,0x10,0x48,0x28,0x10,0x54,0x44,0x44,
		0x40,0x04,0x40,0x04,0x24,0x4c,0x28,0x28,0x28,0x10,0x20,0x08,0x10,0x20,0x00,0x55,

		// line #6
		0x00,0x10,0x00,0x50,0x10,0x84,0x76,0x00,0x02,0x80,0x10,0x10,0x80,0x00,0xc0,0x80,
		0x3c,0x38,0x7e,0x3c,0x04,0x3c,0x3c,0x10,0x3c,0x3c,0x00,0x20,0x02,0x00,0x80,0x10,
		0x38,0x82,0x7c,0x1c,0x78,0x7e,0x40,0x1c,0x42,0x38,0x3c,0x42,0x7e,0x82,0x42,0x18,
		0x40,0x1a,0x42,0x3c,0x10,0x3c,0x10,0x44,0x82,0x10,0x7e,0x0e,0x02,0xe0,0x00,0xfe,
		0x00,0x3c,0x78,0x38,0x3c,0x38,0x10,0x38,0x44,0x10,0x30,0x24,0x10,0x54,0x44,0x38,
		0x40,0x04,0x40,0x78,0x18,0x34,0x10,0x28,0x44,0x60,0x7c,0x06,0x10,0xc0,0x00,0xaa,

		// line #7
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x55,
};
